//
//  CRLibraryItem.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/19/09.
//  Copyright 2009 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// CRLibraryItemBase
//////////////////////////////////////////////////////////////////////
@interface CRLibraryItemBase : NSObject<CRLibraryItem>
{
	NSString*	name;
	NSString*	category;
	NSSet*		tags;
	NSDate*		lastModified;
	BOOL		isSystem;
}

@property (nonatomic, copy)		NSString*	name;
@property (nonatomic, copy)		NSString*	category;
@property (nonatomic, copy)		NSSet*		tags;
@property (nonatomic, copy)		NSDate*		lastModified;
@property (nonatomic, assign)	BOOL		isSystem;

- (void)initializeItem;
- (NSArray *)flushableProperties;
- (void)transferUserDataFromItem:(id<CRLibraryItem>)item;

@end